#ffmp4cnv_inc.py

#std_ffmpeg.pyを改造してimportして利用する形式に
'''
改造内容
・調整又は作成する関数
  →ffmpeg,ffprobe存在確認
    checkffmpeg()
  →元動画の情報取得
    getffprobe()
  →audioストリーム選択
 　 getjpnaudio() ＆ getaudiochoices()
  →映像サイズ縮小の選択
    getmovdownscale(),movdownscale(), selectmovscale()
  →動画の音量（max_volume）を取得する
    volumedetect()
	
このファイルの最終更新日
2023.7.8
  def doconv()にresults引数を追加
2023.7.3
  def volumedetect()を追加した。音量調整用
2023.6.20
  def doconv()においてffmpegの[error]を拾うようにした。
  ただし、ffmpeg -loglevel level+infoオプションが必要
2023.6.15
  def strtimetosec()の正規表現を変更
2023.6.8
  オーディオ情報のJPN判別について修正
2023.6.7
  音声ストリームのビットレートが取得できていなかったのでre条件を修正
2023.4.27
  音声ストリームを手動で選択する処理にバグがあったので修正

'''
from tkinter import *
from tkinter import simpledialog as simpl
from tkinter import messagebox as mbx
from datetime import *
import os,os.path,sys
import re
from subprocess import Popen, PIPE, STDOUT
import platform

# global 変数
##cursoroff = "\x1b[?25l"
##cursoron = "\x1b[?25h"

#windowsの場合Popenで黒画面が表示されるようなのでこれで非表示になればと
if platform.system()=='Windows':
  from subprocess import CREATE_NO_WINDOW
  cflag = CREATE_NO_WINDOW
else:
  cflag = 0

#コマンドをshell実行してその出力をyieldで返す------------
def yield_subpout(cmd):
  #subpは呼び出し側での中止に使われている
  #subpretcodeは使われていない
  #global subp,subpretcode
  try:
    #creationflags追加:windows用
    subp = Popen(cmd,stdout=PIPE,stderr=STDOUT,creationflags=cflag)
  except Exception as err:
    #指定されたプログラムがないとき
    raise StopIteration

  while True:
    line = subp.stdout.readline()
    if line:
      try:
        yield line
      except GeneratorExit:  #呼び出し側の.close()で中止を制御する。
        subp.terminate()
        break
    elif subp.poll() is not None:
      #サププロセスの終了コード
      #subpretcode = subp.returncode
      break
  
  
#yieldで渡されるffprobeの出力を整理して返す----------------
#cmd : ffprobe <video_file>
def getffprobe(cmd):
  duration=''
  vbitrate=''
  video=[]
  audio=[]
  subtitle=[]
  for line in yield_subpout(cmd=cmd):
    ##decode()でエラーが発生する場合の処理：replace
    line = line.decode("utf-8","replace").strip()
    #Duration
    match_duration = re.search('Duration: (.*?),',line)
    #bitrate
    match_bitrate = re.search('bitrate: ([0-9]*) kb/s',line)
    #videostr : yuv.*?(\(.*?\)|)  yuvの項目で()がある場合とない場合がある
    #Stream のlang部分が()の場合と[]の場合がある
    #Stream番号直後の(<lang>)がない場合がある：videoのlangは意味なし？
    ##videostr = 'Stream #([0-9]?:[0-9]?)[\(\[](\w*)[\)\]]: Video: (.*?),'+\
    ##           ' yuv.*?(\(.*?\)|), ([0-9]*x[0-9]*)'
    ##次のreではVideoのlangがある場合()or[]付になる
    videostr = r'Stream #([0-9]?:[0-9]?)(.*?): Video: (.*?),'+\
               r' yuv.*?(\(.*?\)|), ([0-9]*x[0-9]*)'
    #videoストリーム番号とコーデックのみ
    #videosubstr = 'Stream #([0-9]?:[0-9]?).*? Video: (.*?),.*'
    #2023.6.7 修正
    videosubstr = 'Stream #([0-9]?:[0-9]?).*?: Video: (.*?),.*'
    match_video = re.search(videostr,line)
    match_videosub = re.search(videosubstr,line)
    #audioのビットレートがない場合がある
    #2023.6.7 bitrateの取得についてre条件修正
    #audiostr = 'Stream #([0-9]?:[0-9]?)[\(\[](\w*)[\)\]]: Audio: (.*?),'+\
    #           ' ([0-9]*?) Hz, (.*?),.*?(, ([0-9]*?) kb/s)|(.*?)'
    #2023.6.7 更にLang情報取得について簡略化
    audiostr = 'Stream #([0-9]?:[0-9]?)(.*?): Audio: (.*?),'+\
               ' ([0-9]*?) Hz, (.*?),.*?(, ([0-9]*?) kb/s)|(.*?)'
    #audioストリーム番号とコーデックのみ
    #audiosubstr = 'Stream #([0-9]?:[0-9]?).*? Audio: (.*?),.*'
    #2023.6.7修正
    audiosubstr = 'Stream #([0-9]?:[0-9]?).*?: Audio: (.*?),.*'
    match_audio = re.search(audiostr,line)
    match_audiosub = re.search(audiosubstr,line)
    #2023.6.9 subtitleのre条件を簡略化
    #subttlstr = 'Stream #([0-9]?:[0-9]?)[\(\[](\w*)[\)\]]: Subtitle: '
    subttlstr = 'Stream #([0-9]?:[0-9]?)(.*?): Subtitle: '
    match_subttl = re.search(subttlstr,line)
    if match_duration:
      duration = match_duration.group(1)
    if match_bitrate:
      vbitrate = match_bitrate.group(1)

    #video,audioの辞書データの区分は'line'キーの有無で
    #Video Stream
    if match_videosub:
      #2023.6.7 and match_video.group(0)を追加
      if match_video and match_video.group(0):
        
        lwk = match_video.group(2)
        #2023.6.8 ()を外さない。audioに合わせた
        #lwkres = re.search('\W(.*?)\W',lwk)
        #lwk = lwkres.group(1) if lwkres else lwk
          
        video.append({'stream':match_video.group(1),
                      ##'lang':match_video.group(2),
                      'lang':lwk,
                      'codec':match_video.group(3),
                      'size':match_video.group(5)})  #4はyuvの項目で使った
      else: #詳細が一致しない場合は行全体文字列を追加
        video.append({'stream':match_videosub.group(1),
                      'lang':'',
                      'codec':match_videosub.group(2),
                      'size':'',
                      'line':match_videosub.group(0)})
    #audio Stream
    if match_audiosub:
      #2023.6.7 and match_audio.group(0)を追加
      if match_audio and match_audio.group(0):
        audio.append({'stream':match_audio.group(1),
                      'lang':match_audio.group(2),
                      'codec':match_audio.group(3),
                      'samprate':match_audio.group(4),
                      'stereo':match_audio.group(5),
                      'abitrate':match_audio.group(7)}) #6はor()で使った
      else: #詳細が一致しない場合は行全体を追加
        audio.append({'stream':match_audiosub.group(1),
                      'lang':'',
                      'codec':match_audiosub.group(2),
                      'samprate':'',
                      'stereo':'',
                      'abitrate':'',
                      'line':match_audiosub.group(0)})
        
    if match_subttl:
      subtitle.append({'stream':match_subttl.group(1),
                       'lang':match_subttl.group(2)})

  return duration,vbitrate,video,audio,subtitle


#ffmpeg存在チェック
def checkffmpeg(parent=None):
  wh = 'where' if platform.system()=='Windows' else 'which'
  cmdlist = [[wh,'ffprobe'],[wh,'ffmpeg']]
  cmdfound = {}
  for cmd in cmdlist:
    for line in yield_subpout(cmd):
      line = line.decode('utf-8','replace').strip()
      if re.search(cmd[1],line):
        cmdfound[cmd[1]] = line

  if not 'ffprobe' in cmdfound or not 'ffmpeg' in cmdfound:
    #waitexit('ffprobe,ffmpegが見つかりません')
    mbx.showerror('エラー','ffprobe,ffmpegが見つかりません',
                  parent=parent)
    return False
  else:
    return True

#日本語audioストリーム番号を返す
#複数音声があってどれがJPNか分からない場合は''を返す
#戻り値：[True|False,strm | '']
#通常：[True,strm] or [True,''] ←選択が必要
#異常：[False,''] ←audio情報がない
def getjpnaudio(srcmov):
  #audio stream lang=JPN or 先頭　Audioも１つ
  strm = ''
  if srcmov['Audio']:
    for au in srcmov['Audio']:
      #jpnを含む場合に変更 2023.6.8
      #if au['lang'].upper()=='JPN':
      res = re.search('JPN',au['lang'].upper())
      if res & res.group(0):
        strm = au['stream']
        break
    if not strm:
      #audioが１つしかないがJPNではない場合
      if len(srcmov['Audio'])==1:
        strm = srcmov['Audio'][0]['stream']
      #else:  #
      #  strm = audiochoice()
    return [True,strm]
  else:  #srcmov['Audio']情報がない場合　異常
    return [False,strm]

#このダイアログが実際に稼働する機会があるかどうか
#audio選択ダイアログ -----------------------
class audioselect(simpl.Dialog):
  def __init__(self,parent,title,srcmov,fpath=None):
    self.srcmov = srcmov
    self.fpath = fpath
    super().__init__(parent,title)
    self.update_idletasks()

  def body(self,master):
    self.fr = Frame(self)
    txt = ''
    if self.fpath:
      txt = os.path.basename(self.fpath) + '\n'
    txt += '音声ストリームを選択してください'
    Label(self.fr,text=txt).pack(anchor=W)
    self.Radvar = IntVar(value=0)
    choices = self.getchoices()
    val=0
    for i in choices:
      Radiobutton(self.fr,text=i,value=val,variable=self.Radvar).pack(
        anchor=W)
      val += 1
    self.fr.pack(padx=5,pady=5)

  #ラジオボタン用の選択項目をリストで返す
  def getchoices(self):
    choices = []
    for au in self.srcmov['Audio']:
      if 'line' in au:
        choices.append(au['line'])
      else:
        text = 'Stream #'+au['stream']+' '+\
            au['lang']+' '+au['codec']+' '+au['stereo']
        choices.append(text)
    return choices

  def buttonbox(self):
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok, default=ACTIVE)
    w.pack(side=LEFT, padx=5, pady=5)

    self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.ok)

    box.pack()

  def cancel(self, event=None):
    #閉じる前に現在のラジオボタンの値をresultに
    #選ばないという選択肢はない
    self.result = self.Radvar.get()
    # put focus back to the parent window
    if self.parent is not None:
        self.parent.focus_set()
    self.destroy()
#----------------------------
      

#audio情報に複数の候補がある場合の選択結果を返す
#（JPNに該当がない場合）
def getaudiochoices(srcmov,parent=None,fpath=None):
  res = audioselect(parent,'音声を選択',srcmov,fpath)
  return srcmov['Audio'][res.result]['stream']

#横、縦の現在のサイズから縮小size候補を返す
#xsizeは320からの80刻み。
#ysizeはアスペクト比を元にした計算値（少数第1位を四捨五入）
#戻り値：[[xsize,ysize],..]
#アスペクト比で計算されたy値が偶数でないとffmpegがエラーを吐く
#Y値を自動(-1)にせずに偶数で直指定するしかない。
def movdownscale(xcur,ycur,limit=320):
  movsizes=[]
  if xcur <= limit:
    return []
  #des[0]:商 des[1]:余り
  des = divmod(xcur - limit,80)
  for i in range(des[0]):
    xsize = limit + 80*i
    ysize = int(round(ycur * xsize / xcur, 0))
    #ysizeが奇数なら偶数にする（-1）
    ydiv = divmod(ysize,2)
    ysize = ysize -1 if ydiv[1] else ysize
    movsizes.append([xsize,ysize])
  return movsizes

#映像スケール文字列('<xsize>x<ysize>')を受けて
#主な縮小サイズ[xsize,ysize]のリストを返す
def getmovdownscale(sizestr):
  sizere = re.search('([0-9]{2,5})x([0-9]{2,5})',sizestr)
  xcur = int(sizere.group(1))
  ycur = int(sizere.group(2))
  return movdownscale(xcur,ycur)

#映像の縮小サイズを選択する------------------
class scaleselect(simpl.Dialog):
  def __init__(self,parent,title,srcmov,srcpath,samesizevar):
    self.srcmov = srcmov
    self.srcpath = srcpath
    self.samesizevar = samesizevar
    super().__init__(parent,title)
    self.update_idletasks()
    
  def body(self,master):
    self.fr = Frame(self)
    txt = ''
    if self.srcpath:
      txt = os.path.basename(self.srcpath) + '\n'
    txt += '縮小サイズを選択してください。'
    Label(self.fr,text=txt).pack()
    Label(self.fr,text='元動画サイズ：{}'.format(
      self.srcmov['Video'][0]['size'])).pack()
    self.movsizes = getmovdownscale(self.srcmov['Video'][0]['size'])
    #[[X0,Y0],[X1,Y1],,] --> ['X0xY0','X1xY1',,]
    self.movsizes2 = ['{}x{}'.format(x,y) for x,y in self.movsizes]
    self.spbx = Spinbox(self.fr,values=tuple(self.movsizes2))
    self.spbx.pack()
    if self.samesizevar:
      Checkbutton(self.fr,text='同サイズの映像に同じ設定をする',
                  variable=self.samesizevar).pack()
    self.fr.pack()

  def buttonbox(self):
    box = Frame(self)
    w = Button(box, text="決定", width=10, command=self.ok, default=ACTIVE)
    w.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="縮小しない", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    box.pack()

  def apply(self):
    spin = self.spbx.get()
    xsize,ysize = self.movsizes[self.movsizes2.index(spin)]
    scaleparamstr = '-vf scale='+str(xsize)+':'+str(ysize)
    #self.result : [x_size,y_size] 数値
    #self.result = self.movesizes[self.movsizes2.index(spin)]
    self.result = scaleparamstr
#--------------------------------------------------

#縮小サイズを選択して返す
#戻り値：縮小サイズ文字列又はNone
def selectmovscale(parent,srcmov,fpath=None,samesizevar=None):
  res = scaleselect(parent,'縮小サイズ選択',srcmov,fpath,samesizevar)
  return res.result

#-----------------------------------------------------
#変換実行
#進捗表示用のダイアログpbdlgの存在を前提としている
#strfulltimeは'00:00:00'形式
#戻り値：True | False
#ffmpeg -loglevel level+info で'[error]'を拾う予定 戻り値も変更
#results:戻り値用の配列
def doconv(cmd,strfulltime,stopflg,pbdlg,results=[],showall=False):
  #global prctime

  #print('doconv {}'.format(pnum))  #ok
  fulltimesec = strtimetosec(strfulltime)
  yisubp = yield_subpout(cmd=cmd)

  #ここで進捗表示ラベルを挿入
  pbdlg.addprglabel()
  #[error]メッセージを拾う
  errors = []
  for line in yisubp:
    ##decode()でエラーが発生する場合の処理：replace
    line = line.decode("utf-8","replace").strip()
    if showall:
      print(line)
    #[error]取得
    erres = re.search(r'\[error\].*',line)
    if erres and erres.group(0):
      errors.append(line)
    res = re.search('frame=.*? time=(.*) bitrate=.*',line)
    #res = re.search('time=(.*) bitrate=.*',line)
    if res:
      #この値をプログレスバーに反映
      try:
        prgint = round(strtimetosec(res.group(1))/fulltimesec*100)
      #画像など１秒未満のfulltimesecで除算する場合がある
      #その場合は変換率100%で返す
      except ZeroDivisionError:
        prgint = 100
      pbdlg.updateprglabel(prgint)
    #呼び出し元のモジュール内のstopflgを参照する
    if stopflg.getstopflg():
      #subprocess側でGeneratreExitが発生してsubprocessが止まる予定
      yisubp.close()
      #.close()したあとで値を取得すると例外が発生するので即False return
      #return False
      #呼び出し側で中止する場合でも念の為errorsを返す
      results.extend([False,errors])
      return [False,errors]
  #return True
  #errorsを返す　エラーが発生していてもTrueで戻る
  results.extend([True,errors])
  return [True,errors]

#---------------------------------------------------
#時間文字列を秒数に変換する
def strtimetosec(strtime):
  #strtime: 00:00:00.00
  #restr = '(\d{2}):(\d{2}):(\d{2})\.'
  #2023.6.15修正　少数以下は無視するから。また、'0:0:0'にも対応させる
  #2025.5.4修正　
  #  動画先頭でstrtime引数に書式に合致しない値'N/A'などが渡されることがある
  #  その場合には 0 を返すようにした。
  restr = r'(\d{1,2}):(\d{1,2}):(\d{1,2})'
  res = re.search(restr,strtime)
  if res:
    return int(res.group(1))*3600+int(res.group(2))*60+int(res.group(3))
  else:
    print('what? '+strtime)
    return 0

#--------------------------------------------------
#動画の音量（max_volume）を取得する
#戻り値：[maxvolue_str,error_list]
def volumedetect(fpath):
  cmd = 'ffmpeg -loglevel level+info -i'.split()
  cmd.append(fpath)
  cmd.extend('-vn -af volumedetect -f null -'.split())
  #print(cmd)
  errors = []
  maxvol = ''
  for line in yield_subpout(cmd=cmd):
    ##decode()でエラーが発生する場合の処理：replace
    line = line.decode("utf-8","replace").strip()
    #error取得
    reserr = re.search(r'(\[error\].*)',line)
    #maxvolume取得
    resvol = re.search('max_volume: (.*?) dB',line)
    if reserr:
      errors.append(reserr.group(1))
    if resvol:
      maxvol = resvol.group(1)
  return [maxvol,errors]


#===============================================================
#・・・　ここまでがffmp4cnv_incの内容　・・・
#===============================================================

#実行中のスクリプト情報取得
def getcurpaths():
  #Trueならfrozen環境
  if getattr(sys,'frozen',False):
    #frozen環境
    return {'curscript_path':os.path.abspath(sys.executable),
            'curscript_base':os.path.basename(sys.executable),
            'curscript_dir':os.path.dirname(sys.executable)}
  else:
    #通常環境
    return {'curscript_path':os.path.abspath(os.path.realpath(__file__)),
            'curscript_base':os.path.basename(os.path.realpath(__file__)),
            'curscript_dir':os.path.dirname(os.path.realpath(__file__))}
    
#変換元、変換先のディレクトリをファイルに保存する
def writelastdir():
  lfile = paths['curscript_dir']+'/'+lastdir
  try:
    fp = open(lfile,'w')  #上書き
  except Exception as err:
    return err
  wstr = 'source_dir:'+paths['source_dir']+'\n'
  wstr += 'edest_dir:'+paths['edest_dir']+'\n'
  try:
    fp.write(wstr)
  except Exception as err:
    fp.close()
    return err
  fp.close()
  return 0

#起動時に直前の変換元・先のディレクトリを読み込む
#ただし、存在するディレクトリのみ
def readlastdir():
  global paths
  
  lfile = paths['curscript_dir']+'/'+lastdir
  try:
    fp = open(lfile,'r')
  except Exception as err:
    return err
  lines = fp.readlines()
  fp.close()
  for line in lines:
    reres = re.search('source_dir:(.*)',line)
    if reres:
      sdir = reres.group(1).strip()
      if os.path.isdir(sdir):
        paths['source_dir'] = sdir
    reres = re.search('edest_dir:(.*)',line)
    if reres:
      edir = reres.group(1).strip()
      if os.path.isdir(edir):
        paths['edest_dir'] = edir
  return 0

#---------------------------------------------------
if __name__=='__main__':
  pass
 
