'''
extcodecs.py
拡張子とコーデックのデータ

汎用mp4-codec:
'libx264 -profile:v baseline -level 3.0 -pix_fmt yuv420p'
'''
Extcodecdic = {
  '.mp4':{
    'video':['libx264 -profile:v baseline -level 3.0 -pix_fmt yuv420p',
             'libx264','h264','h264_qsv','h264_nvenc','h264_vaapi',
             'hevc','hevc_qsv','hevc_nvenc','mpeg4'],
    'audio':['aac','mp3','ac3','vorbis']},
  '.m4a':{
    'video':['libx264','h264','h264_qsv','h264_nvenc','h264_vaapi',
             'hevc','hevc_qsv','hevc_nvenc','mpeg4'],
    'audio':['aac','mp3','ac3','vorbis']},
  '.mkv':{
    'video':['h264','libx264','mpeg4'],
    'audio':['aac','mp3','vorbis','pcm_s16le','pcm_s16be']},
  '.avi':{
    'video':['h264','libx264','hevc','libx265','mpeg4'],
    'audio':['aac','mp3','pcm_s16le','pcm_s16be']},
  '.mov':{
    'video':['h264','libx264','mpeg4'],
    'audio':['aac','mp3','pcm_s16le','pcm_s16be']},
  '.qt':{
    'video':['h264','libx264','mpeg4'],
    'audio':['aac','mp3','pcm_s16le','pcm_s16be']},
  '.wmv':{
    'video':['wmv2','wmv1'],  #wmv3はデコードのみ
    'audio':['wmav2','wmav1','mp3','aac']},
  '.m2ts':{
    'video':['h264','libx264','mpeg2video'],
    'audio':['aac','ac3','mp3']},
  '.ts':{
    'video':['h264','libx264','mpeg2video'],
    'audio':['aac','ac3','mp3']},
  '.mpeg':{
    'video':['mpeg2video','mpeg1video','mpeg4'],
    'audio':['aac','mp3','pcm_s16le','pcm_s16be']},
  '.mpg':{
    'video':['mpeg2video','mpeg1video','mpeg4'],
    'audio':['aac','mp3','pcm_s16le','pcm_s16be']},
  '.flv':{
    'video':['flv1','h263','h264','libx264'],
    'audio':['mp3','aac','adpcm_g722','adpcm_g726','adpcm_g726le']},
  '.asf':{
    'video':['h264','libx264','mpeg4'],
    'audio':['aac','mp3','pcm_s16le','pcm_s16be','flac']},
  '.vob':{
    'video':['mpeg2video','mpeg1video'],
    'audio':['pcm_s16le','pcm_s16be','ac3','mp2']},
  '.webm':{
    'video':['vp9','vp8'],
    'audio':['vorbis']},
}


#拡張子(.あり)から対応コーデック(ffmpeg引数)の辞書を返す{'video':[],'audio':[]}
#拡張子が指定されない場合はすべてのコーデックの辞書を返す
def ext2codecs(ext=None):
  if ext and ext.lower() in Extcodecdic:
    return Extcodecdic[ext]
  else:
    vcodecs = set()
    acodecs = set()
    for k in Extcodecdic:
      vcodecs = vcodecs.union(Extcodecdic[k]['video'])
      acodecs = acodecs.union(Extcodecdic[k]['audio'])
    return {'video':list(vcodecs),'audio':list(acodecs)}

#コーデックから対応拡張子のリストを返す
#vcodec,acodecがともに指定されない場合はすべての拡張子を返す
def codecs2exts(vcodec=None,acodec=None):
  #指定なしの場合
  if not vcodec and not acodec:
    return list(Extcodecdic.keys())
  extlist = []
  for k in Extcodecdic:
    if vcodec and acodec:
      if vcodec in Extcodecdic[k]['video'] and \
            acodec in Extcodecdic[k]['audio']:
        extlist.append(k)
    elif vcodec and not acodec:
      if vcodec in Extcodecdic[k]['video']:
        extlist.append(k)
    elif not vcodec and acodec:
      if acodec in Extcodecdic[k]['audio']:
        extlist.append(k)
  return extlist
