'''
helpmessage_inc.py

'''
from tkinter import *
from tkinter import simpledialog as smpldlg

#------------------------------------------------------
#ヘルプメッセージなどを表示するだけのダイアログ
#基本はラベル表示。text or image (iamgeはtkinterで表示可能なobjに限る)
#func:text,imageを無視してwidget配置を外部のfuncに任せる。
#buttontxt:ボタンにOK以外のテキストを表示する場合に使用する
#justify:複数行テキストの配置　CENTER,LEFT,RIGHT
class helpdialog(smpldlg.Dialog):
  def __init__(self,parent,title=None,
               text=None,image=None,func=None,buttontxt=None,
               justify=CENTER,padx=0,pady=0):
    self.text = text
    self.image = image
    self.buttontxt = buttontxt
    self.func = func
    self.justify = justify
    self.padx = padx
    self.pady = pady
    super().__init__(parent,title)

  def body(self,master):
    fr = Frame(self)
    if self.func:
      w = self.func(fr)
    elif self.image:
      w = Label(fr,image=self.image)
    elif self.text:
      w = Label(fr,text=self.text,justify=self.justify)
    else:
      w = Label(fr,text='No message')
    w.pack(padx=self.padx,pady=self.pady)
    fr.pack()

  def buttonbox(self):
    box = Frame(self)
    txt = self.buttontxt if self.buttontxt else 'OK'
      
    w = Button(box, text=txt, width=10, command=self.ok, default=ACTIVE)
    w.pack()
    self.bind("<Return>", self.ok)
    box.pack()

#-------------------------------------------------------------
if __name__=='__main__':
  from PIL import ImageTk,Image
  file = 'cropping.png'
  def nortext():
    tx = '通常のテキストメッセージ'
    dlg = helpdialog(root,title='通常テキスト',text=tx,buttontxt='閉じる')
  def imagefile():
    img = Image.open(file)
    tkimg = ImageTk.PhotoImage(img)
    dlg = helpdialog(root,title='イメージファイル',image=tkimg,buttontxt='close')
  def create():
    dlg = helpdialog(root,title='widget生成呼び出し',func=func,buttontxt='exit')
  #ダイアログ本体に設置するウィジェットを生成する関数
  #parent:ウィジェットの親フレームなど
  #戻り値：ダイアログに配置するウィジェット
  def func(parent):
    fr = Frame(parent)
    Button(fr,text='単なるボタン').pack()
    return fr

  root = Tk()
  Button(root,text='通常のテキスト',command=nortext).pack(expand=1,fill='x')
  Button(root,text='イメージファイル',command=imagefile).pack()
  Button(root,text='生成関数呼び出し',command=create).pack()
  root.mainloop()
